// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(SubscriptionValidationResponseConverter))]
    public partial class SubscriptionValidationResponse : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(ValidationResponse))
            {
                writer.WritePropertyName("validationResponse"u8);
                writer.WriteStringValue(ValidationResponse);
            }
            writer.WriteEndObject();
        }

        internal static SubscriptionValidationResponse DeserializeSubscriptionValidationResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string validationResponse = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("validationResponse"u8))
                {
                    validationResponse = property.Value.GetString();
                    continue;
                }
            }
            return new SubscriptionValidationResponse(validationResponse);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SubscriptionValidationResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSubscriptionValidationResponse(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class SubscriptionValidationResponseConverter : JsonConverter<SubscriptionValidationResponse>
        {
            public override void Write(Utf8JsonWriter writer, SubscriptionValidationResponse model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override SubscriptionValidationResponse Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeSubscriptionValidationResponse(document.RootElement);
            }
        }
    }
}
