// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(SubscriptionValidationEventDataConverter))]
    public partial class SubscriptionValidationEventData
    {
        internal static SubscriptionValidationEventData DeserializeSubscriptionValidationEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string validationCode = default;
            string validationUrl = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("validationCode"u8))
                {
                    validationCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("validationUrl"u8))
                {
                    validationUrl = property.Value.GetString();
                    continue;
                }
            }
            return new SubscriptionValidationEventData(validationCode, validationUrl);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SubscriptionValidationEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSubscriptionValidationEventData(document.RootElement);
        }

        internal partial class SubscriptionValidationEventDataConverter : JsonConverter<SubscriptionValidationEventData>
        {
            public override void Write(Utf8JsonWriter writer, SubscriptionValidationEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override SubscriptionValidationEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeSubscriptionValidationEventData(document.RootElement);
            }
        }
    }
}
