// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for an Microsoft.Storage.StorageTaskAssignmentQueued event. </summary>
    public partial class StorageTaskAssignmentQueuedEventData
    {
        /// <summary> Initializes a new instance of <see cref="StorageTaskAssignmentQueuedEventData"/>. </summary>
        internal StorageTaskAssignmentQueuedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskAssignmentQueuedEventData"/>. </summary>
        /// <param name="queuedOn"> The time at which a storage task was queued. </param>
        /// <param name="taskExecutionId"> The execution id for a storage task. </param>
        internal StorageTaskAssignmentQueuedEventData(DateTimeOffset? queuedOn, string taskExecutionId)
        {
            QueuedOn = queuedOn;
            TaskExecutionId = taskExecutionId;
        }

        /// <summary> The time at which a storage task was queued. </summary>
        public DateTimeOffset? QueuedOn { get; }
        /// <summary> The execution id for a storage task. </summary>
        public string TaskExecutionId { get; }
    }
}
