// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(StorageTaskAssignmentQueuedEventDataConverter))]
    public partial class StorageTaskAssignmentQueuedEventData
    {
        internal static StorageTaskAssignmentQueuedEventData DeserializeStorageTaskAssignmentQueuedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? queuedDateTime = default;
            string taskExecutionId = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("queuedDateTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    queuedDateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("taskExecutionId"u8))
                {
                    taskExecutionId = property.Value.GetString();
                    continue;
                }
            }
            return new StorageTaskAssignmentQueuedEventData(queuedDateTime, taskExecutionId);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static StorageTaskAssignmentQueuedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeStorageTaskAssignmentQueuedEventData(document.RootElement);
        }

        internal partial class StorageTaskAssignmentQueuedEventDataConverter : JsonConverter<StorageTaskAssignmentQueuedEventData>
        {
            public override void Write(Utf8JsonWriter writer, StorageTaskAssignmentQueuedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override StorageTaskAssignmentQueuedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeStorageTaskAssignmentQueuedEventData(document.RootElement);
            }
        }
    }
}
