// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The status for a storage task. </summary>
    public readonly partial struct StorageTaskAssignmentCompletedStatus : IEquatable<StorageTaskAssignmentCompletedStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageTaskAssignmentCompletedStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageTaskAssignmentCompletedStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static StorageTaskAssignmentCompletedStatus Succeeded { get; } = new StorageTaskAssignmentCompletedStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static StorageTaskAssignmentCompletedStatus Failed { get; } = new StorageTaskAssignmentCompletedStatus(FailedValue);
        /// <summary> Determines if two <see cref="StorageTaskAssignmentCompletedStatus"/> values are the same. </summary>
        public static bool operator ==(StorageTaskAssignmentCompletedStatus left, StorageTaskAssignmentCompletedStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageTaskAssignmentCompletedStatus"/> values are not the same. </summary>
        public static bool operator !=(StorageTaskAssignmentCompletedStatus left, StorageTaskAssignmentCompletedStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageTaskAssignmentCompletedStatus"/>. </summary>
        public static implicit operator StorageTaskAssignmentCompletedStatus(string value) => new StorageTaskAssignmentCompletedStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageTaskAssignmentCompletedStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageTaskAssignmentCompletedStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
