// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for an Microsoft.Storage.StorageTaskAssignmentCompleted event. </summary>
    public partial class StorageTaskAssignmentCompletedEventData
    {
        /// <summary> Initializes a new instance of <see cref="StorageTaskAssignmentCompletedEventData"/>. </summary>
        internal StorageTaskAssignmentCompletedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskAssignmentCompletedEventData"/>. </summary>
        /// <param name="status"> The status for a storage task. </param>
        /// <param name="completedOn"> The time at which a storage task was completed. </param>
        /// <param name="taskExecutionId"> The execution id for a storage task. </param>
        /// <param name="taskName"> The task name for a storage task. </param>
        /// <param name="summaryReportBlobUri"> The summary report blob url for a storage task. </param>
        internal StorageTaskAssignmentCompletedEventData(StorageTaskAssignmentCompletedStatus? status, DateTimeOffset? completedOn, string taskExecutionId, string taskName, Uri summaryReportBlobUri)
        {
            Status = status;
            CompletedOn = completedOn;
            TaskExecutionId = taskExecutionId;
            TaskName = taskName;
            SummaryReportBlobUri = summaryReportBlobUri;
        }

        /// <summary> The status for a storage task. </summary>
        public StorageTaskAssignmentCompletedStatus? Status { get; }
        /// <summary> The time at which a storage task was completed. </summary>
        public DateTimeOffset? CompletedOn { get; }
        /// <summary> The execution id for a storage task. </summary>
        public string TaskExecutionId { get; }
        /// <summary> The task name for a storage task. </summary>
        public string TaskName { get; }
        /// <summary> The summary report blob url for a storage task. </summary>
        public Uri SummaryReportBlobUri { get; }
    }
}
