// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(StorageLifecyclePolicyCompletedEventDataConverter))]
    public partial class StorageLifecyclePolicyCompletedEventData
    {
        internal static StorageLifecyclePolicyCompletedEventData DeserializeStorageLifecyclePolicyCompletedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string scheduleTime = default;
            StorageLifecyclePolicyActionSummaryDetail deleteSummary = default;
            StorageLifecyclePolicyActionSummaryDetail tierToCoolSummary = default;
            StorageLifecyclePolicyActionSummaryDetail tierToColdSummary = default;
            StorageLifecyclePolicyActionSummaryDetail tierToArchiveSummary = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("scheduleTime"u8))
                {
                    scheduleTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("deleteSummary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    deleteSummary = StorageLifecyclePolicyActionSummaryDetail.DeserializeStorageLifecyclePolicyActionSummaryDetail(property.Value);
                    continue;
                }
                if (property.NameEquals("tierToCoolSummary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tierToCoolSummary = StorageLifecyclePolicyActionSummaryDetail.DeserializeStorageLifecyclePolicyActionSummaryDetail(property.Value);
                    continue;
                }
                if (property.NameEquals("tierToColdSummary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tierToColdSummary = StorageLifecyclePolicyActionSummaryDetail.DeserializeStorageLifecyclePolicyActionSummaryDetail(property.Value);
                    continue;
                }
                if (property.NameEquals("tierToArchiveSummary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tierToArchiveSummary = StorageLifecyclePolicyActionSummaryDetail.DeserializeStorageLifecyclePolicyActionSummaryDetail(property.Value);
                    continue;
                }
            }
            return new StorageLifecyclePolicyCompletedEventData(scheduleTime, deleteSummary, tierToCoolSummary, tierToColdSummary, tierToArchiveSummary);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static StorageLifecyclePolicyCompletedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeStorageLifecyclePolicyCompletedEventData(document.RootElement);
        }

        internal partial class StorageLifecyclePolicyCompletedEventDataConverter : JsonConverter<StorageLifecyclePolicyCompletedEventData>
        {
            public override void Write(Utf8JsonWriter writer, StorageLifecyclePolicyCompletedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override StorageLifecyclePolicyCompletedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeStorageLifecyclePolicyCompletedEventData(document.RootElement);
            }
        }
    }
}
