// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Execution statistics of a specific policy action in a Blob Management cycle. </summary>
    public partial class StorageLifecyclePolicyActionSummaryDetail
    {
        /// <summary> Initializes a new instance of <see cref="StorageLifecyclePolicyActionSummaryDetail"/>. </summary>
        internal StorageLifecyclePolicyActionSummaryDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageLifecyclePolicyActionSummaryDetail"/>. </summary>
        /// <param name="totalObjectsCount"> Total number of objects to be acted on by this action. </param>
        /// <param name="successCount"> Number of success operations of this action. </param>
        /// <param name="errorList"> Error messages of this action if any. </param>
        internal StorageLifecyclePolicyActionSummaryDetail(long? totalObjectsCount, long? successCount, string errorList)
        {
            TotalObjectsCount = totalObjectsCount;
            SuccessCount = successCount;
            ErrorList = errorList;
        }

        /// <summary> Total number of objects to be acted on by this action. </summary>
        public long? TotalObjectsCount { get; }
        /// <summary> Number of success operations of this action. </summary>
        public long? SuccessCount { get; }
        /// <summary> Error messages of this action if any. </summary>
        public string ErrorList { get; }
    }
}
