// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class StorageLifecyclePolicyActionSummaryDetail
    {
        internal static StorageLifecyclePolicyActionSummaryDetail DeserializeStorageLifecyclePolicyActionSummaryDetail(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long? totalObjectsCount = default;
            long? successCount = default;
            string errorList = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("totalObjectsCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalObjectsCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("successCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    successCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("errorList"u8))
                {
                    errorList = property.Value.GetString();
                    continue;
                }
            }
            return new StorageLifecyclePolicyActionSummaryDetail(totalObjectsCount, successCount, errorList);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static StorageLifecyclePolicyActionSummaryDetail FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeStorageLifecyclePolicyActionSummaryDetail(document.RootElement);
        }
    }
}
