// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for an Microsoft.Storage.BlobInventoryPolicyCompleted event. </summary>
    public partial class StorageBlobInventoryPolicyCompletedEventData
    {
        /// <summary> Initializes a new instance of <see cref="StorageBlobInventoryPolicyCompletedEventData"/>. </summary>
        internal StorageBlobInventoryPolicyCompletedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageBlobInventoryPolicyCompletedEventData"/>. </summary>
        /// <param name="scheduleDateTime"> The time at which inventory policy was scheduled. </param>
        /// <param name="accountName"> The account name for which inventory policy is registered. </param>
        /// <param name="ruleName"> The rule name for inventory policy. </param>
        /// <param name="policyRunStatus"> The status of inventory run, it can be Succeeded/PartiallySucceeded/Failed. </param>
        /// <param name="policyRunStatusMessage"> The status message for inventory run. </param>
        /// <param name="policyRunId"> The policy run id for inventory run. </param>
        /// <param name="manifestBlobUrl"> The blob URL for manifest file for inventory run. </param>
        internal StorageBlobInventoryPolicyCompletedEventData(DateTimeOffset? scheduleDateTime, string accountName, string ruleName, string policyRunStatus, string policyRunStatusMessage, string policyRunId, string manifestBlobUrl)
        {
            ScheduleDateTime = scheduleDateTime;
            AccountName = accountName;
            RuleName = ruleName;
            PolicyRunStatus = policyRunStatus;
            PolicyRunStatusMessage = policyRunStatusMessage;
            PolicyRunId = policyRunId;
            ManifestBlobUrl = manifestBlobUrl;
        }

        /// <summary> The time at which inventory policy was scheduled. </summary>
        public DateTimeOffset? ScheduleDateTime { get; }
        /// <summary> The account name for which inventory policy is registered. </summary>
        public string AccountName { get; }
        /// <summary> The rule name for inventory policy. </summary>
        public string RuleName { get; }
        /// <summary> The status of inventory run, it can be Succeeded/PartiallySucceeded/Failed. </summary>
        public string PolicyRunStatus { get; }
        /// <summary> The status message for inventory run. </summary>
        public string PolicyRunStatusMessage { get; }
        /// <summary> The policy run id for inventory run. </summary>
        public string PolicyRunId { get; }
        /// <summary> The blob URL for manifest file for inventory run. </summary>
        public string ManifestBlobUrl { get; }
    }
}
