// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(StorageBlobInventoryPolicyCompletedEventDataConverter))]
    public partial class StorageBlobInventoryPolicyCompletedEventData
    {
        internal static StorageBlobInventoryPolicyCompletedEventData DeserializeStorageBlobInventoryPolicyCompletedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? scheduleDateTime = default;
            string accountName = default;
            string ruleName = default;
            string policyRunStatus = default;
            string policyRunStatusMessage = default;
            string policyRunId = default;
            string manifestBlobUrl = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("scheduleDateTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scheduleDateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("accountName"u8))
                {
                    accountName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ruleName"u8))
                {
                    ruleName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("policyRunStatus"u8))
                {
                    policyRunStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("policyRunStatusMessage"u8))
                {
                    policyRunStatusMessage = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("policyRunId"u8))
                {
                    policyRunId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("manifestBlobUrl"u8))
                {
                    manifestBlobUrl = property.Value.GetString();
                    continue;
                }
            }
            return new StorageBlobInventoryPolicyCompletedEventData(
                scheduleDateTime,
                accountName,
                ruleName,
                policyRunStatus,
                policyRunStatusMessage,
                policyRunId,
                manifestBlobUrl);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static StorageBlobInventoryPolicyCompletedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeStorageBlobInventoryPolicyCompletedEventData(document.RootElement);
        }

        internal partial class StorageBlobInventoryPolicyCompletedEventDataConverter : JsonConverter<StorageBlobInventoryPolicyCompletedEventData>
        {
            public override void Write(Utf8JsonWriter writer, StorageBlobInventoryPolicyCompletedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override StorageBlobInventoryPolicyCompletedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeStorageBlobInventoryPolicyCompletedEventData(document.RootElement);
            }
        }
    }
}
