// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Kind of environment where app service plan is. </summary>
    public readonly partial struct StampKind : IEquatable<StampKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StampKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StampKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PublicValue = "Public";
        private const string AseV1Value = "AseV1";
        private const string AseV2Value = "AseV2";

        /// <summary> App Service Plan is running on a public stamp. </summary>
        public static StampKind Public { get; } = new StampKind(PublicValue);
        /// <summary> App Service Plan is running on an App Service Environment V1. </summary>
        public static StampKind AseV1 { get; } = new StampKind(AseV1Value);
        /// <summary> App Service Plan is running on an App Service Environment V2. </summary>
        public static StampKind AseV2 { get; } = new StampKind(AseV2Value);
        /// <summary> Determines if two <see cref="StampKind"/> values are the same. </summary>
        public static bool operator ==(StampKind left, StampKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StampKind"/> values are not the same. </summary>
        public static bool operator !=(StampKind left, StampKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StampKind"/>. </summary>
        public static implicit operator StampKind(string value) => new StampKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StampKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StampKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
