// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Describes the schema of the common properties across all ARN system topic events. </summary>
    public partial class ResourceNotificationsResourceUpdatedEventData
    {
        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsResourceUpdatedEventData"/>. </summary>
        internal ResourceNotificationsResourceUpdatedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsResourceUpdatedEventData"/>. </summary>
        /// <param name="resourceDetails"> resourceInfo details for update event. </param>
        /// <param name="operationalDetails"> details about operational info. </param>
        /// <param name="apiVersion"> api version of the resource properties bag. </param>
        internal ResourceNotificationsResourceUpdatedEventData(ResourceNotificationsResourceUpdatedDetails resourceDetails, ResourceNotificationsOperationalDetails operationalDetails, string apiVersion)
        {
            ResourceDetails = resourceDetails;
            OperationalDetails = operationalDetails;
            ApiVersion = apiVersion;
        }

        /// <summary> resourceInfo details for update event. </summary>
        public ResourceNotificationsResourceUpdatedDetails ResourceDetails { get; }
        /// <summary> details about operational info. </summary>
        public ResourceNotificationsOperationalDetails OperationalDetails { get; }
        /// <summary> api version of the resource properties bag. </summary>
        public string ApiVersion { get; }
    }
}
