// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Describes the schema of the properties under resource info which are common across all ARN system topic events. </summary>
    public partial class ResourceNotificationsResourceUpdatedDetails
    {
        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsResourceUpdatedDetails"/>. </summary>
        internal ResourceNotificationsResourceUpdatedDetails()
        {
            ResourceTags = new ChangeTrackingDictionary<string, string>();
            Properties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsResourceUpdatedDetails"/>. </summary>
        /// <param name="id"> id of the resource for which the event is being emitted. </param>
        /// <param name="name"> name of the resource for which the event is being emitted. </param>
        /// <param name="resourceType"> the type of the resource for which the event is being emitted. </param>
        /// <param name="location"> the location of the resource for which the event is being emitted. </param>
        /// <param name="resourceTags"> the tags on the resource for which the event is being emitted. </param>
        /// <param name="properties"> properties in the payload of the resource for which the event is being emitted. </param>
        internal ResourceNotificationsResourceUpdatedDetails(string id, string name, string resourceType, string location, IReadOnlyDictionary<string, string> resourceTags, IReadOnlyDictionary<string, object> properties)
        {
            Id = id;
            Name = name;
            ResourceType = resourceType;
            Location = location;
            ResourceTags = resourceTags;
            Properties = properties;
        }
        /// <summary> properties in the payload of the resource for which the event is being emitted. </summary>
        public IReadOnlyDictionary<string, object> Properties { get; }
    }
}
