// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(ResourceNotificationsResourceManagementDeletedEventDataConverter))]
    public partial class ResourceNotificationsResourceManagementDeletedEventData
    {
        internal static ResourceNotificationsResourceManagementDeletedEventData DeserializeResourceNotificationsResourceManagementDeletedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceNotificationsResourceDeletedDetails resourceInfo = default;
            ResourceNotificationsOperationalDetails operationalInfo = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("resourceInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resourceInfo = ResourceNotificationsResourceDeletedDetails.DeserializeResourceNotificationsResourceDeletedDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("operationalInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    operationalInfo = ResourceNotificationsOperationalDetails.DeserializeResourceNotificationsOperationalDetails(property.Value);
                    continue;
                }
            }
            return new ResourceNotificationsResourceManagementDeletedEventData(resourceInfo, operationalInfo);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new ResourceNotificationsResourceManagementDeletedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeResourceNotificationsResourceManagementDeletedEventData(document.RootElement);
        }

        internal partial class ResourceNotificationsResourceManagementDeletedEventDataConverter : JsonConverter<ResourceNotificationsResourceManagementDeletedEventData>
        {
            public override void Write(Utf8JsonWriter writer, ResourceNotificationsResourceManagementDeletedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override ResourceNotificationsResourceManagementDeletedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeResourceNotificationsResourceManagementDeletedEventData(document.RootElement);
            }
        }
    }
}
