// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class ResourceNotificationsOperationalDetails
    {
        internal static ResourceNotificationsOperationalDetails DeserializeResourceNotificationsOperationalDetails(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? resourceEventTime = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("resourceEventTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resourceEventTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new ResourceNotificationsOperationalDetails(resourceEventTime);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ResourceNotificationsOperationalDetails FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeResourceNotificationsOperationalDetails(document.RootElement);
        }
    }
}
