// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class MapsGeofenceGeometry
    {
        internal static MapsGeofenceGeometry DeserializeMapsGeofenceGeometry(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string deviceId = default;
            float? distance = default;
            string geometryId = default;
            float? nearestLat = default;
            float? nearestLon = default;
            string udId = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deviceId"u8))
                {
                    deviceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("distance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    distance = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("geometryId"u8))
                {
                    geometryId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nearestLat"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nearestLat = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("nearestLon"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nearestLon = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("udId"u8))
                {
                    udId = property.Value.GetString();
                    continue;
                }
            }
            return new MapsGeofenceGeometry(
                deviceId,
                distance,
                geometryId,
                nearestLat,
                nearestLon,
                udId);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MapsGeofenceGeometry FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMapsGeofenceGeometry(document.RootElement);
        }
    }
}
