// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Geofence event (GeofenceEntered, GeofenceExited, GeofenceResult). </summary>
    public partial class MapsGeofenceEventProperties
    {
        /// <summary> Initializes a new instance of <see cref="MapsGeofenceEventProperties"/>. </summary>
        internal MapsGeofenceEventProperties()
        {
            ExpiredGeofenceGeometryId = new ChangeTrackingList<string>();
            Geometries = new ChangeTrackingList<MapsGeofenceGeometry>();
            InvalidPeriodGeofenceGeometryId = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MapsGeofenceEventProperties"/>. </summary>
        /// <param name="expiredGeofenceGeometryId"> Lists of the geometry ID of the geofence which is expired relative to the user time in the request. </param>
        /// <param name="geometries"> Lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence. </param>
        /// <param name="invalidPeriodGeofenceGeometryId"> Lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request. </param>
        /// <param name="isEventPublished"> True if at least one event is published to the Azure Maps event subscriber, false if no event is published to the Azure Maps event subscriber. </param>
        internal MapsGeofenceEventProperties(IReadOnlyList<string> expiredGeofenceGeometryId, IReadOnlyList<MapsGeofenceGeometry> geometries, IReadOnlyList<string> invalidPeriodGeofenceGeometryId, bool? isEventPublished)
        {
            ExpiredGeofenceGeometryId = expiredGeofenceGeometryId;
            Geometries = geometries;
            InvalidPeriodGeofenceGeometryId = invalidPeriodGeofenceGeometryId;
            IsEventPublished = isEventPublished;
        }

        /// <summary> Lists of the geometry ID of the geofence which is expired relative to the user time in the request. </summary>
        public IReadOnlyList<string> ExpiredGeofenceGeometryId { get; }
        /// <summary> Lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence. </summary>
        public IReadOnlyList<MapsGeofenceGeometry> Geometries { get; }
        /// <summary> Lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request. </summary>
        public IReadOnlyList<string> InvalidPeriodGeofenceGeometryId { get; }
        /// <summary> True if at least one event is published to the Azure Maps event subscriber, false if no event is published to the Azure Maps event subscriber. </summary>
        public bool? IsEventPublished { get; }
    }
}
