// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(MachineLearningServicesRunStatusChangedEventDataConverter))]
    public partial class MachineLearningServicesRunStatusChangedEventData
    {
        internal static MachineLearningServicesRunStatusChangedEventData DeserializeMachineLearningServicesRunStatusChangedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string experimentId = default;
            string experimentName = default;
            string runId = default;
            string runType = default;
            object runTags = default;
            object runProperties = default;
            string runStatus = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("experimentId"u8))
                {
                    experimentId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("experimentName"u8))
                {
                    experimentName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("runId"u8))
                {
                    runId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("runType"u8))
                {
                    runType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("runTags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    runTags = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("runProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    runProperties = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("runStatus"u8))
                {
                    runStatus = property.Value.GetString();
                    continue;
                }
            }
            return new MachineLearningServicesRunStatusChangedEventData(
                experimentId,
                experimentName,
                runId,
                runType,
                runTags,
                runProperties,
                runStatus);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MachineLearningServicesRunStatusChangedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMachineLearningServicesRunStatusChangedEventData(document.RootElement);
        }

        internal partial class MachineLearningServicesRunStatusChangedEventDataConverter : JsonConverter<MachineLearningServicesRunStatusChangedEventData>
        {
            public override void Write(Utf8JsonWriter writer, MachineLearningServicesRunStatusChangedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override MachineLearningServicesRunStatusChangedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeMachineLearningServicesRunStatusChangedEventData(document.RootElement);
            }
        }
    }
}
