// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of FHIR resource type enumeration. </summary>
    public readonly partial struct HealthcareFhirResourceType : IEquatable<HealthcareFhirResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthcareFhirResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthcareFhirResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AccountValue = "Account";
        private const string ActivityDefinitionValue = "ActivityDefinition";
        private const string AdverseEventValue = "AdverseEvent";
        private const string AllergyIntoleranceValue = "AllergyIntolerance";
        private const string AppointmentValue = "Appointment";
        private const string AppointmentResponseValue = "AppointmentResponse";
        private const string AuditEventValue = "AuditEvent";
        private const string BasicValue = "Basic";
        private const string BinaryValue = "Binary";
        private const string BiologicallyDerivedProductValue = "BiologicallyDerivedProduct";
        private const string BodySiteValue = "BodySite";
        private const string BodyStructureValue = "BodyStructure";
        private const string BundleValue = "Bundle";
        private const string CapabilityStatementValue = "CapabilityStatement";
        private const string CarePlanValue = "CarePlan";
        private const string CareTeamValue = "CareTeam";
        private const string CatalogEntryValue = "CatalogEntry";
        private const string ChargeItemValue = "ChargeItem";
        private const string ChargeItemDefinitionValue = "ChargeItemDefinition";
        private const string ClaimValue = "Claim";
        private const string ClaimResponseValue = "ClaimResponse";
        private const string ClinicalImpressionValue = "ClinicalImpression";
        private const string CodeSystemValue = "CodeSystem";
        private const string CommunicationValue = "Communication";
        private const string CommunicationRequestValue = "CommunicationRequest";
        private const string CompartmentDefinitionValue = "CompartmentDefinition";
        private const string CompositionValue = "Composition";
        private const string ConceptMapValue = "ConceptMap";
        private const string ConditionValue = "Condition";
        private const string ConsentValue = "Consent";
        private const string ContractValue = "Contract";
        private const string CoverageValue = "Coverage";
        private const string CoverageEligibilityRequestValue = "CoverageEligibilityRequest";
        private const string CoverageEligibilityResponseValue = "CoverageEligibilityResponse";
        private const string DataElementValue = "DataElement";
        private const string DetectedIssueValue = "DetectedIssue";
        private const string DeviceValue = "Device";
        private const string DeviceComponentValue = "DeviceComponent";
        private const string DeviceDefinitionValue = "DeviceDefinition";
        private const string DeviceMetricValue = "DeviceMetric";
        private const string DeviceRequestValue = "DeviceRequest";
        private const string DeviceUseStatementValue = "DeviceUseStatement";
        private const string DiagnosticReportValue = "DiagnosticReport";
        private const string DocumentManifestValue = "DocumentManifest";
        private const string DocumentReferenceValue = "DocumentReference";
        private const string DomainResourceValue = "DomainResource";
        private const string EffectEvidenceSynthesisValue = "EffectEvidenceSynthesis";
        private const string EligibilityRequestValue = "EligibilityRequest";
        private const string EligibilityResponseValue = "EligibilityResponse";
        private const string EncounterValue = "Encounter";
        private const string EndpointValue = "Endpoint";
        private const string EnrollmentRequestValue = "EnrollmentRequest";
        private const string EnrollmentResponseValue = "EnrollmentResponse";
        private const string EpisodeOfCareValue = "EpisodeOfCare";
        private const string EventDefinitionValue = "EventDefinition";
        private const string EvidenceValue = "Evidence";
        private const string EvidenceVariableValue = "EvidenceVariable";
        private const string ExampleScenarioValue = "ExampleScenario";
        private const string ExpansionProfileValue = "ExpansionProfile";
        private const string ExplanationOfBenefitValue = "ExplanationOfBenefit";
        private const string FamilyMemberHistoryValue = "FamilyMemberHistory";
        private const string FlagValue = "Flag";
        private const string GoalValue = "Goal";
        private const string GraphDefinitionValue = "GraphDefinition";
        private const string GroupValue = "Group";
        private const string GuidanceResponseValue = "GuidanceResponse";
        private const string HealthcareServiceValue = "HealthcareService";
        private const string ImagingManifestValue = "ImagingManifest";
        private const string ImagingStudyValue = "ImagingStudy";
        private const string ImmunizationValue = "Immunization";
        private const string ImmunizationEvaluationValue = "ImmunizationEvaluation";
        private const string ImmunizationRecommendationValue = "ImmunizationRecommendation";
        private const string ImplementationGuideValue = "ImplementationGuide";
        private const string InsurancePlanValue = "InsurancePlan";
        private const string InvoiceValue = "Invoice";
        private const string LibraryValue = "Library";
        private const string LinkageValue = "Linkage";
        private const string ListValue = "List";
        private const string LocationValue = "Location";
        private const string MeasureValue = "Measure";
        private const string MeasureReportValue = "MeasureReport";
        private const string MediaValue = "Media";
        private const string MedicationValue = "Medication";
        private const string MedicationAdministrationValue = "MedicationAdministration";
        private const string MedicationDispenseValue = "MedicationDispense";
        private const string MedicationKnowledgeValue = "MedicationKnowledge";
        private const string MedicationRequestValue = "MedicationRequest";
        private const string MedicationStatementValue = "MedicationStatement";
        private const string MedicinalProductValue = "MedicinalProduct";
        private const string MedicinalProductAuthorizationValue = "MedicinalProductAuthorization";
        private const string MedicinalProductContraindicationValue = "MedicinalProductContraindication";
        private const string MedicinalProductIndicationValue = "MedicinalProductIndication";
        private const string MedicinalProductIngredientValue = "MedicinalProductIngredient";
        private const string MedicinalProductInteractionValue = "MedicinalProductInteraction";
        private const string MedicinalProductManufacturedValue = "MedicinalProductManufactured";
        private const string MedicinalProductPackagedValue = "MedicinalProductPackaged";
        private const string MedicinalProductPharmaceuticalValue = "MedicinalProductPharmaceutical";
        private const string MedicinalProductUndesirableEffectValue = "MedicinalProductUndesirableEffect";
        private const string MessageDefinitionValue = "MessageDefinition";
        private const string MessageHeaderValue = "MessageHeader";
        private const string MolecularSequenceValue = "MolecularSequence";
        private const string NamingSystemValue = "NamingSystem";
        private const string NutritionOrderValue = "NutritionOrder";
        private const string ObservationValue = "Observation";
        private const string ObservationDefinitionValue = "ObservationDefinition";
        private const string OperationDefinitionValue = "OperationDefinition";
        private const string OperationOutcomeValue = "OperationOutcome";
        private const string OrganizationValue = "Organization";
        private const string OrganizationAffiliationValue = "OrganizationAffiliation";
        private const string ParametersValue = "Parameters";
        private const string PatientValue = "Patient";
        private const string PaymentNoticeValue = "PaymentNotice";
        private const string PaymentReconciliationValue = "PaymentReconciliation";
        private const string PersonValue = "Person";
        private const string PlanDefinitionValue = "PlanDefinition";
        private const string PractitionerValue = "Practitioner";
        private const string PractitionerRoleValue = "PractitionerRole";
        private const string ProcedureValue = "Procedure";
        private const string ProcedureRequestValue = "ProcedureRequest";
        private const string ProcessRequestValue = "ProcessRequest";
        private const string ProcessResponseValue = "ProcessResponse";
        private const string ProvenanceValue = "Provenance";
        private const string QuestionnaireValue = "Questionnaire";
        private const string QuestionnaireResponseValue = "QuestionnaireResponse";
        private const string ReferralRequestValue = "ReferralRequest";
        private const string RelatedPersonValue = "RelatedPerson";
        private const string RequestGroupValue = "RequestGroup";
        private const string ResearchDefinitionValue = "ResearchDefinition";
        private const string ResearchElementDefinitionValue = "ResearchElementDefinition";
        private const string ResearchStudyValue = "ResearchStudy";
        private const string ResearchSubjectValue = "ResearchSubject";
        private const string ResourceValue = "Resource";
        private const string RiskAssessmentValue = "RiskAssessment";
        private const string RiskEvidenceSynthesisValue = "RiskEvidenceSynthesis";
        private const string ScheduleValue = "Schedule";
        private const string SearchParameterValue = "SearchParameter";
        private const string SequenceValue = "Sequence";
        private const string ServiceDefinitionValue = "ServiceDefinition";
        private const string ServiceRequestValue = "ServiceRequest";
        private const string SlotValue = "Slot";
        private const string SpecimenValue = "Specimen";
        private const string SpecimenDefinitionValue = "SpecimenDefinition";
        private const string StructureDefinitionValue = "StructureDefinition";
        private const string StructureMapValue = "StructureMap";
        private const string SubscriptionValue = "Subscription";
        private const string SubstanceValue = "Substance";
        private const string SubstanceNucleicAcidValue = "SubstanceNucleicAcid";
        private const string SubstancePolymerValue = "SubstancePolymer";
        private const string SubstanceProteinValue = "SubstanceProtein";
        private const string SubstanceReferenceInformationValue = "SubstanceReferenceInformation";
        private const string SubstanceSourceMaterialValue = "SubstanceSourceMaterial";
        private const string SubstanceSpecificationValue = "SubstanceSpecification";
        private const string SupplyDeliveryValue = "SupplyDelivery";
        private const string SupplyRequestValue = "SupplyRequest";
        private const string TaskValue = "Task";
        private const string TerminologyCapabilitiesValue = "TerminologyCapabilities";
        private const string TestReportValue = "TestReport";
        private const string TestScriptValue = "TestScript";
        private const string ValueSetValue = "ValueSet";
        private const string VerificationResultValue = "VerificationResult";
        private const string VisionPrescriptionValue = "VisionPrescription";

        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Account { get; } = new HealthcareFhirResourceType(AccountValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ActivityDefinition { get; } = new HealthcareFhirResourceType(ActivityDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType AdverseEvent { get; } = new HealthcareFhirResourceType(AdverseEventValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType AllergyIntolerance { get; } = new HealthcareFhirResourceType(AllergyIntoleranceValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Appointment { get; } = new HealthcareFhirResourceType(AppointmentValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType AppointmentResponse { get; } = new HealthcareFhirResourceType(AppointmentResponseValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType AuditEvent { get; } = new HealthcareFhirResourceType(AuditEventValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Basic { get; } = new HealthcareFhirResourceType(BasicValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Binary { get; } = new HealthcareFhirResourceType(BinaryValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType BiologicallyDerivedProduct { get; } = new HealthcareFhirResourceType(BiologicallyDerivedProductValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType BodySite { get; } = new HealthcareFhirResourceType(BodySiteValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType BodyStructure { get; } = new HealthcareFhirResourceType(BodyStructureValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Bundle { get; } = new HealthcareFhirResourceType(BundleValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType CapabilityStatement { get; } = new HealthcareFhirResourceType(CapabilityStatementValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType CarePlan { get; } = new HealthcareFhirResourceType(CarePlanValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType CareTeam { get; } = new HealthcareFhirResourceType(CareTeamValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType CatalogEntry { get; } = new HealthcareFhirResourceType(CatalogEntryValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ChargeItem { get; } = new HealthcareFhirResourceType(ChargeItemValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType ChargeItemDefinition { get; } = new HealthcareFhirResourceType(ChargeItemDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Claim { get; } = new HealthcareFhirResourceType(ClaimValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ClaimResponse { get; } = new HealthcareFhirResourceType(ClaimResponseValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ClinicalImpression { get; } = new HealthcareFhirResourceType(ClinicalImpressionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType CodeSystem { get; } = new HealthcareFhirResourceType(CodeSystemValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Communication { get; } = new HealthcareFhirResourceType(CommunicationValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType CommunicationRequest { get; } = new HealthcareFhirResourceType(CommunicationRequestValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType CompartmentDefinition { get; } = new HealthcareFhirResourceType(CompartmentDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Composition { get; } = new HealthcareFhirResourceType(CompositionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ConceptMap { get; } = new HealthcareFhirResourceType(ConceptMapValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Condition { get; } = new HealthcareFhirResourceType(ConditionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Consent { get; } = new HealthcareFhirResourceType(ConsentValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Contract { get; } = new HealthcareFhirResourceType(ContractValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Coverage { get; } = new HealthcareFhirResourceType(CoverageValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType CoverageEligibilityRequest { get; } = new HealthcareFhirResourceType(CoverageEligibilityRequestValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType CoverageEligibilityResponse { get; } = new HealthcareFhirResourceType(CoverageEligibilityResponseValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType DataElement { get; } = new HealthcareFhirResourceType(DataElementValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType DetectedIssue { get; } = new HealthcareFhirResourceType(DetectedIssueValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Device { get; } = new HealthcareFhirResourceType(DeviceValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType DeviceComponent { get; } = new HealthcareFhirResourceType(DeviceComponentValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType DeviceDefinition { get; } = new HealthcareFhirResourceType(DeviceDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType DeviceMetric { get; } = new HealthcareFhirResourceType(DeviceMetricValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType DeviceRequest { get; } = new HealthcareFhirResourceType(DeviceRequestValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType DeviceUseStatement { get; } = new HealthcareFhirResourceType(DeviceUseStatementValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType DiagnosticReport { get; } = new HealthcareFhirResourceType(DiagnosticReportValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType DocumentManifest { get; } = new HealthcareFhirResourceType(DocumentManifestValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType DocumentReference { get; } = new HealthcareFhirResourceType(DocumentReferenceValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType DomainResource { get; } = new HealthcareFhirResourceType(DomainResourceValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType EffectEvidenceSynthesis { get; } = new HealthcareFhirResourceType(EffectEvidenceSynthesisValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType EligibilityRequest { get; } = new HealthcareFhirResourceType(EligibilityRequestValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType EligibilityResponse { get; } = new HealthcareFhirResourceType(EligibilityResponseValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Encounter { get; } = new HealthcareFhirResourceType(EncounterValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Endpoint { get; } = new HealthcareFhirResourceType(EndpointValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType EnrollmentRequest { get; } = new HealthcareFhirResourceType(EnrollmentRequestValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType EnrollmentResponse { get; } = new HealthcareFhirResourceType(EnrollmentResponseValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType EpisodeOfCare { get; } = new HealthcareFhirResourceType(EpisodeOfCareValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType EventDefinition { get; } = new HealthcareFhirResourceType(EventDefinitionValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType Evidence { get; } = new HealthcareFhirResourceType(EvidenceValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType EvidenceVariable { get; } = new HealthcareFhirResourceType(EvidenceVariableValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType ExampleScenario { get; } = new HealthcareFhirResourceType(ExampleScenarioValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType ExpansionProfile { get; } = new HealthcareFhirResourceType(ExpansionProfileValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ExplanationOfBenefit { get; } = new HealthcareFhirResourceType(ExplanationOfBenefitValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType FamilyMemberHistory { get; } = new HealthcareFhirResourceType(FamilyMemberHistoryValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Flag { get; } = new HealthcareFhirResourceType(FlagValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Goal { get; } = new HealthcareFhirResourceType(GoalValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType GraphDefinition { get; } = new HealthcareFhirResourceType(GraphDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Group { get; } = new HealthcareFhirResourceType(GroupValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType GuidanceResponse { get; } = new HealthcareFhirResourceType(GuidanceResponseValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType HealthcareService { get; } = new HealthcareFhirResourceType(HealthcareServiceValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType ImagingManifest { get; } = new HealthcareFhirResourceType(ImagingManifestValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ImagingStudy { get; } = new HealthcareFhirResourceType(ImagingStudyValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Immunization { get; } = new HealthcareFhirResourceType(ImmunizationValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType ImmunizationEvaluation { get; } = new HealthcareFhirResourceType(ImmunizationEvaluationValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ImmunizationRecommendation { get; } = new HealthcareFhirResourceType(ImmunizationRecommendationValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ImplementationGuide { get; } = new HealthcareFhirResourceType(ImplementationGuideValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType InsurancePlan { get; } = new HealthcareFhirResourceType(InsurancePlanValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType Invoice { get; } = new HealthcareFhirResourceType(InvoiceValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Library { get; } = new HealthcareFhirResourceType(LibraryValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Linkage { get; } = new HealthcareFhirResourceType(LinkageValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType List { get; } = new HealthcareFhirResourceType(ListValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Location { get; } = new HealthcareFhirResourceType(LocationValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Measure { get; } = new HealthcareFhirResourceType(MeasureValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType MeasureReport { get; } = new HealthcareFhirResourceType(MeasureReportValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Media { get; } = new HealthcareFhirResourceType(MediaValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Medication { get; } = new HealthcareFhirResourceType(MedicationValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType MedicationAdministration { get; } = new HealthcareFhirResourceType(MedicationAdministrationValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType MedicationDispense { get; } = new HealthcareFhirResourceType(MedicationDispenseValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicationKnowledge { get; } = new HealthcareFhirResourceType(MedicationKnowledgeValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType MedicationRequest { get; } = new HealthcareFhirResourceType(MedicationRequestValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType MedicationStatement { get; } = new HealthcareFhirResourceType(MedicationStatementValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicinalProduct { get; } = new HealthcareFhirResourceType(MedicinalProductValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicinalProductAuthorization { get; } = new HealthcareFhirResourceType(MedicinalProductAuthorizationValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicinalProductContraindication { get; } = new HealthcareFhirResourceType(MedicinalProductContraindicationValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicinalProductIndication { get; } = new HealthcareFhirResourceType(MedicinalProductIndicationValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicinalProductIngredient { get; } = new HealthcareFhirResourceType(MedicinalProductIngredientValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicinalProductInteraction { get; } = new HealthcareFhirResourceType(MedicinalProductInteractionValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicinalProductManufactured { get; } = new HealthcareFhirResourceType(MedicinalProductManufacturedValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicinalProductPackaged { get; } = new HealthcareFhirResourceType(MedicinalProductPackagedValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicinalProductPharmaceutical { get; } = new HealthcareFhirResourceType(MedicinalProductPharmaceuticalValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MedicinalProductUndesirableEffect { get; } = new HealthcareFhirResourceType(MedicinalProductUndesirableEffectValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType MessageDefinition { get; } = new HealthcareFhirResourceType(MessageDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType MessageHeader { get; } = new HealthcareFhirResourceType(MessageHeaderValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType MolecularSequence { get; } = new HealthcareFhirResourceType(MolecularSequenceValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType NamingSystem { get; } = new HealthcareFhirResourceType(NamingSystemValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType NutritionOrder { get; } = new HealthcareFhirResourceType(NutritionOrderValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Observation { get; } = new HealthcareFhirResourceType(ObservationValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType ObservationDefinition { get; } = new HealthcareFhirResourceType(ObservationDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType OperationDefinition { get; } = new HealthcareFhirResourceType(OperationDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType OperationOutcome { get; } = new HealthcareFhirResourceType(OperationOutcomeValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Organization { get; } = new HealthcareFhirResourceType(OrganizationValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType OrganizationAffiliation { get; } = new HealthcareFhirResourceType(OrganizationAffiliationValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Parameters { get; } = new HealthcareFhirResourceType(ParametersValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Patient { get; } = new HealthcareFhirResourceType(PatientValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType PaymentNotice { get; } = new HealthcareFhirResourceType(PaymentNoticeValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType PaymentReconciliation { get; } = new HealthcareFhirResourceType(PaymentReconciliationValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Person { get; } = new HealthcareFhirResourceType(PersonValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType PlanDefinition { get; } = new HealthcareFhirResourceType(PlanDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Practitioner { get; } = new HealthcareFhirResourceType(PractitionerValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType PractitionerRole { get; } = new HealthcareFhirResourceType(PractitionerRoleValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Procedure { get; } = new HealthcareFhirResourceType(ProcedureValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType ProcedureRequest { get; } = new HealthcareFhirResourceType(ProcedureRequestValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType ProcessRequest { get; } = new HealthcareFhirResourceType(ProcessRequestValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType ProcessResponse { get; } = new HealthcareFhirResourceType(ProcessResponseValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Provenance { get; } = new HealthcareFhirResourceType(ProvenanceValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Questionnaire { get; } = new HealthcareFhirResourceType(QuestionnaireValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType QuestionnaireResponse { get; } = new HealthcareFhirResourceType(QuestionnaireResponseValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType ReferralRequest { get; } = new HealthcareFhirResourceType(ReferralRequestValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType RelatedPerson { get; } = new HealthcareFhirResourceType(RelatedPersonValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType RequestGroup { get; } = new HealthcareFhirResourceType(RequestGroupValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType ResearchDefinition { get; } = new HealthcareFhirResourceType(ResearchDefinitionValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType ResearchElementDefinition { get; } = new HealthcareFhirResourceType(ResearchElementDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ResearchStudy { get; } = new HealthcareFhirResourceType(ResearchStudyValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ResearchSubject { get; } = new HealthcareFhirResourceType(ResearchSubjectValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Resource { get; } = new HealthcareFhirResourceType(ResourceValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType RiskAssessment { get; } = new HealthcareFhirResourceType(RiskAssessmentValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType RiskEvidenceSynthesis { get; } = new HealthcareFhirResourceType(RiskEvidenceSynthesisValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Schedule { get; } = new HealthcareFhirResourceType(ScheduleValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType SearchParameter { get; } = new HealthcareFhirResourceType(SearchParameterValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType Sequence { get; } = new HealthcareFhirResourceType(SequenceValue);
        /// <summary> The FHIR resource type defined in STU3. </summary>
        public static HealthcareFhirResourceType ServiceDefinition { get; } = new HealthcareFhirResourceType(ServiceDefinitionValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType ServiceRequest { get; } = new HealthcareFhirResourceType(ServiceRequestValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Slot { get; } = new HealthcareFhirResourceType(SlotValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Specimen { get; } = new HealthcareFhirResourceType(SpecimenValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType SpecimenDefinition { get; } = new HealthcareFhirResourceType(SpecimenDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType StructureDefinition { get; } = new HealthcareFhirResourceType(StructureDefinitionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType StructureMap { get; } = new HealthcareFhirResourceType(StructureMapValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Subscription { get; } = new HealthcareFhirResourceType(SubscriptionValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Substance { get; } = new HealthcareFhirResourceType(SubstanceValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType SubstanceNucleicAcid { get; } = new HealthcareFhirResourceType(SubstanceNucleicAcidValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType SubstancePolymer { get; } = new HealthcareFhirResourceType(SubstancePolymerValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType SubstanceProtein { get; } = new HealthcareFhirResourceType(SubstanceProteinValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType SubstanceReferenceInformation { get; } = new HealthcareFhirResourceType(SubstanceReferenceInformationValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType SubstanceSourceMaterial { get; } = new HealthcareFhirResourceType(SubstanceSourceMaterialValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType SubstanceSpecification { get; } = new HealthcareFhirResourceType(SubstanceSpecificationValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType SupplyDelivery { get; } = new HealthcareFhirResourceType(SupplyDeliveryValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType SupplyRequest { get; } = new HealthcareFhirResourceType(SupplyRequestValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType Task { get; } = new HealthcareFhirResourceType(TaskValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType TerminologyCapabilities { get; } = new HealthcareFhirResourceType(TerminologyCapabilitiesValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType TestReport { get; } = new HealthcareFhirResourceType(TestReportValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType TestScript { get; } = new HealthcareFhirResourceType(TestScriptValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType ValueSet { get; } = new HealthcareFhirResourceType(ValueSetValue);
        /// <summary> The FHIR resource type defined in R4. </summary>
        public static HealthcareFhirResourceType VerificationResult { get; } = new HealthcareFhirResourceType(VerificationResultValue);
        /// <summary> The FHIR resource type defined in STU3 and R4. </summary>
        public static HealthcareFhirResourceType VisionPrescription { get; } = new HealthcareFhirResourceType(VisionPrescriptionValue);
        /// <summary> Determines if two <see cref="HealthcareFhirResourceType"/> values are the same. </summary>
        public static bool operator ==(HealthcareFhirResourceType left, HealthcareFhirResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthcareFhirResourceType"/> values are not the same. </summary>
        public static bool operator !=(HealthcareFhirResourceType left, HealthcareFhirResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthcareFhirResourceType"/>. </summary>
        public static implicit operator HealthcareFhirResourceType(string value) => new HealthcareFhirResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthcareFhirResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthcareFhirResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
