// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.EventHub.CaptureFileCreated event. </summary>
    public partial class EventHubCaptureFileCreatedEventData
    {
        /// <summary> Initializes a new instance of <see cref="EventHubCaptureFileCreatedEventData"/>. </summary>
        internal EventHubCaptureFileCreatedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EventHubCaptureFileCreatedEventData"/>. </summary>
        /// <param name="fileurl"> The path to the capture file. </param>
        /// <param name="fileType"> The file type of the capture file. </param>
        /// <param name="partitionId"> The shard ID. </param>
        /// <param name="sizeInBytes"> The file size. </param>
        /// <param name="eventCount"> The number of events in the file. </param>
        /// <param name="firstSequenceNumber"> The smallest sequence number from the queue. </param>
        /// <param name="lastSequenceNumber"> The last sequence number from the queue. </param>
        /// <param name="firstEnqueueTime"> The first time from the queue. </param>
        /// <param name="lastEnqueueTime"> The last time from the queue. </param>
        internal EventHubCaptureFileCreatedEventData(string fileurl, string fileType, string partitionId, int? sizeInBytes, int? eventCount, int? firstSequenceNumber, int? lastSequenceNumber, DateTimeOffset? firstEnqueueTime, DateTimeOffset? lastEnqueueTime)
        {
            Fileurl = fileurl;
            FileType = fileType;
            PartitionId = partitionId;
            SizeInBytes = sizeInBytes;
            EventCount = eventCount;
            FirstSequenceNumber = firstSequenceNumber;
            LastSequenceNumber = lastSequenceNumber;
            FirstEnqueueTime = firstEnqueueTime;
            LastEnqueueTime = lastEnqueueTime;
        }

        /// <summary> The path to the capture file. </summary>
        public string Fileurl { get; }
        /// <summary> The file type of the capture file. </summary>
        public string FileType { get; }
        /// <summary> The shard ID. </summary>
        public string PartitionId { get; }
        /// <summary> The file size. </summary>
        public int? SizeInBytes { get; }
        /// <summary> The number of events in the file. </summary>
        public int? EventCount { get; }
        /// <summary> The smallest sequence number from the queue. </summary>
        public int? FirstSequenceNumber { get; }
        /// <summary> The last sequence number from the queue. </summary>
        public int? LastSequenceNumber { get; }
        /// <summary> The first time from the queue. </summary>
        public DateTimeOffset? FirstEnqueueTime { get; }
        /// <summary> The last time from the queue. </summary>
        public DateTimeOffset? LastEnqueueTime { get; }
    }
}
