// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(EventGridMqttClientSessionDisconnectedEventDataConverter))]
    public partial class EventGridMqttClientSessionDisconnectedEventData
    {
        internal static EventGridMqttClientSessionDisconnectedEventData DeserializeEventGridMqttClientSessionDisconnectedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string clientSessionName = default;
            long? sequenceNumber = default;
            EventGridMqttClientDisconnectionReason? disconnectionReason = default;
            string clientAuthenticationName = default;
            string clientName = default;
            string namespaceName = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("clientSessionName"u8))
                {
                    clientSessionName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sequenceNumber"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sequenceNumber = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("disconnectionReason"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    disconnectionReason = new EventGridMqttClientDisconnectionReason(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("clientAuthenticationName"u8))
                {
                    clientAuthenticationName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clientName"u8))
                {
                    clientName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("namespaceName"u8))
                {
                    namespaceName = property.Value.GetString();
                    continue;
                }
            }
            return new EventGridMqttClientSessionDisconnectedEventData(
                clientAuthenticationName,
                clientName,
                namespaceName,
                clientSessionName,
                sequenceNumber,
                disconnectionReason);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new EventGridMqttClientSessionDisconnectedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeEventGridMqttClientSessionDisconnectedEventData(document.RootElement);
        }

        internal partial class EventGridMqttClientSessionDisconnectedEventDataConverter : JsonConverter<EventGridMqttClientSessionDisconnectedEventData>
        {
            public override void Write(Utf8JsonWriter writer, EventGridMqttClientSessionDisconnectedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override EventGridMqttClientSessionDisconnectedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeEventGridMqttClientSessionDisconnectedEventData(document.RootElement);
            }
        }
    }
}
