// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for MQTT Client state changes. </summary>
    public partial class EventGridMqttClientEventData
    {
        /// <summary> Initializes a new instance of <see cref="EventGridMqttClientEventData"/>. </summary>
        internal EventGridMqttClientEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EventGridMqttClientEventData"/>. </summary>
        /// <param name="clientAuthenticationName"> Unique identifier for the MQTT client that the client presents to the service for authentication. This case-sensitive string can be up to 128 characters long, and supports UTF-8 characters. </param>
        /// <param name="clientName"> Name of the client resource in the Event Grid namespace. </param>
        /// <param name="namespaceName"> Name of the Event Grid namespace where the MQTT client was created or updated. </param>
        internal EventGridMqttClientEventData(string clientAuthenticationName, string clientName, string namespaceName)
        {
            ClientAuthenticationName = clientAuthenticationName;
            ClientName = clientName;
            NamespaceName = namespaceName;
        }

        /// <summary> Unique identifier for the MQTT client that the client presents to the service for authentication. This case-sensitive string can be up to 128 characters long, and supports UTF-8 characters. </summary>
        public string ClientAuthenticationName { get; }
        /// <summary> Name of the client resource in the Event Grid namespace. </summary>
        public string ClientName { get; }
        /// <summary> Name of the Event Grid namespace where the MQTT client was created or updated. </summary>
        public string NamespaceName { get; }
    }
}
