// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(EventGridMqttClientEventDataConverter))]
    public partial class EventGridMqttClientEventData
    {
        internal static EventGridMqttClientEventData DeserializeEventGridMqttClientEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string clientAuthenticationName = default;
            string clientName = default;
            string namespaceName = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("clientAuthenticationName"u8))
                {
                    clientAuthenticationName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clientName"u8))
                {
                    clientName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("namespaceName"u8))
                {
                    namespaceName = property.Value.GetString();
                    continue;
                }
            }
            return new EventGridMqttClientEventData(clientAuthenticationName, clientName, namespaceName);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static EventGridMqttClientEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeEventGridMqttClientEventData(document.RootElement);
        }

        internal partial class EventGridMqttClientEventDataConverter : JsonConverter<EventGridMqttClientEventData>
        {
            public override void Write(Utf8JsonWriter writer, EventGridMqttClientEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override EventGridMqttClientEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeEventGridMqttClientEventData(document.RootElement);
            }
        }
    }
}
