// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(EventGridMqttClientDeletedEventDataConverter))]
    public partial class EventGridMqttClientDeletedEventData
    {
        internal static EventGridMqttClientDeletedEventData DeserializeEventGridMqttClientDeletedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string clientAuthenticationName = default;
            string clientName = default;
            string namespaceName = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("clientAuthenticationName"u8))
                {
                    clientAuthenticationName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clientName"u8))
                {
                    clientName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("namespaceName"u8))
                {
                    namespaceName = property.Value.GetString();
                    continue;
                }
            }
            return new EventGridMqttClientDeletedEventData(clientAuthenticationName, clientName, namespaceName);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new EventGridMqttClientDeletedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeEventGridMqttClientDeletedEventData(document.RootElement);
        }

        internal partial class EventGridMqttClientDeletedEventDataConverter : JsonConverter<EventGridMqttClientDeletedEventData>
        {
            public override void Write(Utf8JsonWriter writer, EventGridMqttClientDeletedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override EventGridMqttClientDeletedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeEventGridMqttClientDeletedEventData(document.RootElement);
            }
        }
    }
}
