// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(EventGridMqttClientCreatedOrUpdatedEventDataConverter))]
    public partial class EventGridMqttClientCreatedOrUpdatedEventData
    {
        internal static EventGridMqttClientCreatedOrUpdatedEventData DeserializeEventGridMqttClientCreatedOrUpdatedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            EventGridMqttClientState? state = default;
            DateTimeOffset? createdOn = default;
            DateTimeOffset? updatedOn = default;
            IReadOnlyDictionary<string, string> attributes = default;
            string clientAuthenticationName = default;
            string clientName = default;
            string namespaceName = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new EventGridMqttClientState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("createdOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    createdOn = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("updatedOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    updatedOn = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("attributes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    attributes = dictionary;
                    continue;
                }
                if (property.NameEquals("clientAuthenticationName"u8))
                {
                    clientAuthenticationName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clientName"u8))
                {
                    clientName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("namespaceName"u8))
                {
                    namespaceName = property.Value.GetString();
                    continue;
                }
            }
            return new EventGridMqttClientCreatedOrUpdatedEventData(
                clientAuthenticationName,
                clientName,
                namespaceName,
                state,
                createdOn,
                updatedOn,
                attributes ?? new ChangeTrackingDictionary<string, string>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new EventGridMqttClientCreatedOrUpdatedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeEventGridMqttClientCreatedOrUpdatedEventData(document.RootElement);
        }

        internal partial class EventGridMqttClientCreatedOrUpdatedEventDataConverter : JsonConverter<EventGridMqttClientCreatedOrUpdatedEventData>
        {
            public override void Write(Utf8JsonWriter writer, EventGridMqttClientCreatedOrUpdatedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override EventGridMqttClientCreatedOrUpdatedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeEventGridMqttClientCreatedOrUpdatedEventData(document.RootElement);
            }
        }
    }
}
