// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;

namespace Azure.Messaging.EventGrid.Models
{
    /// <summary> Properties of an event published to an Event Grid topic using the EventGrid Schema. </summary>
    internal partial class EventGridEventInternal
    {
        /// <summary> Initializes a new instance of <see cref="EventGridEventInternal"/>. </summary>
        /// <param name="id"> An unique identifier for the event. </param>
        /// <param name="subject"> A resource path relative to the topic path. </param>
        /// <param name="data"> Event data specific to the event type. </param>
        /// <param name="eventType"> The type of the event that occurred. </param>
        /// <param name="eventTime"> The time (in UTC) the event was generated. </param>
        /// <param name="dataVersion"> The schema version of the data object. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/>, <paramref name="subject"/>, <paramref name="eventType"/> or <paramref name="dataVersion"/> is null. </exception>
        public EventGridEventInternal(string id, string subject, JsonElement data, string eventType, DateTimeOffset eventTime, string dataVersion)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(subject, nameof(subject));
            Argument.AssertNotNull(eventType, nameof(eventType));
            Argument.AssertNotNull(dataVersion, nameof(dataVersion));

            Id = id;
            Subject = subject;
            Data = data;
            EventType = eventType;
            EventTime = eventTime;
            DataVersion = dataVersion;
        }

        /// <summary> Initializes a new instance of <see cref="EventGridEventInternal"/>. </summary>
        /// <param name="id"> An unique identifier for the event. </param>
        /// <param name="topic"> The resource path of the event source. </param>
        /// <param name="subject"> A resource path relative to the topic path. </param>
        /// <param name="data"> Event data specific to the event type. </param>
        /// <param name="eventType"> The type of the event that occurred. </param>
        /// <param name="eventTime"> The time (in UTC) the event was generated. </param>
        /// <param name="metadataVersion"> The schema version of the event metadata. </param>
        /// <param name="dataVersion"> The schema version of the data object. </param>
        internal EventGridEventInternal(string id, string topic, string subject, JsonElement data, string eventType, DateTimeOffset eventTime, string metadataVersion, string dataVersion)
        {
            Id = id;
            Topic = topic;
            Subject = subject;
            Data = data;
            EventType = eventType;
            EventTime = eventTime;
            MetadataVersion = metadataVersion;
            DataVersion = dataVersion;
        }

        /// <summary> An unique identifier for the event. </summary>
        public string Id { get; set; }
        /// <summary> The resource path of the event source. </summary>
        public string Topic { get; set; }
        /// <summary> A resource path relative to the topic path. </summary>
        public string Subject { get; set; }
        /// <summary> The type of the event that occurred. </summary>
        public string EventType { get; set; }
        /// <summary> The time (in UTC) the event was generated. </summary>
        public DateTimeOffset EventTime { get; set; }
        /// <summary> The schema version of the event metadata. </summary>
        public string MetadataVersion { get; }
        /// <summary> The schema version of the data object. </summary>
        public string DataVersion { get; set; }
    }
}
