// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class DeviceConnectionStateEventInfo
    {
        internal static DeviceConnectionStateEventInfo DeserializeDeviceConnectionStateEventInfo(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string sequenceNumber = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sequenceNumber"u8))
                {
                    sequenceNumber = property.Value.GetString();
                    continue;
                }
            }
            return new DeviceConnectionStateEventInfo(sequenceNumber);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DeviceConnectionStateEventInfo FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDeviceConnectionStateEventInfo(document.RootElement);
        }
    }
}
