// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(DataBoxCopyStartedEventDataConverter))]
    public partial class DataBoxCopyStartedEventData
    {
        internal static DataBoxCopyStartedEventData DeserializeDataBoxCopyStartedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string serialNumber = default;
            DataBoxStageName? stageName = default;
            DateTimeOffset? stageTime = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("serialNumber"u8))
                {
                    serialNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("stageName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stageName = new DataBoxStageName(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("stageTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stageTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new DataBoxCopyStartedEventData(serialNumber, stageName, stageTime);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DataBoxCopyStartedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDataBoxCopyStartedEventData(document.RootElement);
        }

        internal partial class DataBoxCopyStartedEventDataConverter : JsonConverter<DataBoxCopyStartedEventData>
        {
            public override void Write(Utf8JsonWriter writer, DataBoxCopyStartedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override DataBoxCopyStartedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeDataBoxCopyStartedEventData(document.RootElement);
            }
        }
    }
}
