// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(DataBoxCopyCompletedEventDataConverter))]
    public partial class DataBoxCopyCompletedEventData
    {
        internal static DataBoxCopyCompletedEventData DeserializeDataBoxCopyCompletedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string serialNumber = default;
            DataBoxStageName? stageName = default;
            DateTimeOffset? stageTime = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("serialNumber"u8))
                {
                    serialNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("stageName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stageName = new DataBoxStageName(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("stageTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stageTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new DataBoxCopyCompletedEventData(serialNumber, stageName, stageTime);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DataBoxCopyCompletedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDataBoxCopyCompletedEventData(document.RootElement);
        }

        internal partial class DataBoxCopyCompletedEventDataConverter : JsonConverter<DataBoxCopyCompletedEventData>
        {
            public override void Write(Utf8JsonWriter writer, DataBoxCopyCompletedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override DataBoxCopyCompletedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeDataBoxCopyCompletedEventData(document.RootElement);
            }
        }
    }
}
