// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(ContainerServiceNodePoolRollingEventDataConverter))]
    public partial class ContainerServiceNodePoolRollingEventData
    {
        internal static ContainerServiceNodePoolRollingEventData DeserializeContainerServiceNodePoolRollingEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string nodePoolName = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("nodePoolName"u8))
                {
                    nodePoolName = property.Value.GetString();
                    continue;
                }
            }
            return new ContainerServiceNodePoolRollingEventData(nodePoolName);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ContainerServiceNodePoolRollingEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeContainerServiceNodePoolRollingEventData(document.RootElement);
        }

        internal partial class ContainerServiceNodePoolRollingEventDataConverter : JsonConverter<ContainerServiceNodePoolRollingEventData>
        {
            public override void Write(Utf8JsonWriter writer, ContainerServiceNodePoolRollingEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override ContainerServiceNodePoolRollingEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeContainerServiceNodePoolRollingEventData(document.RootElement);
            }
        }
    }
}
