// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The target of the event. </summary>
    public partial class ContainerRegistryArtifactEventTarget
    {
        /// <summary> Initializes a new instance of <see cref="ContainerRegistryArtifactEventTarget"/>. </summary>
        internal ContainerRegistryArtifactEventTarget()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryArtifactEventTarget"/>. </summary>
        /// <param name="mediaType"> The MIME type of the artifact. </param>
        /// <param name="size"> The size in bytes of the artifact. </param>
        /// <param name="digest"> The digest of the artifact. </param>
        /// <param name="repository"> The repository name of the artifact. </param>
        /// <param name="tag"> The tag of the artifact. </param>
        /// <param name="name"> The name of the artifact. </param>
        /// <param name="version"> The version of the artifact. </param>
        internal ContainerRegistryArtifactEventTarget(string mediaType, long? size, string digest, string repository, string tag, string name, string version)
        {
            MediaType = mediaType;
            Size = size;
            Digest = digest;
            Repository = repository;
            Tag = tag;
            Name = name;
            Version = version;
        }

        /// <summary> The MIME type of the artifact. </summary>
        public string MediaType { get; }
        /// <summary> The size in bytes of the artifact. </summary>
        public long? Size { get; }
        /// <summary> The digest of the artifact. </summary>
        public string Digest { get; }
        /// <summary> The repository name of the artifact. </summary>
        public string Repository { get; }
        /// <summary> The tag of the artifact. </summary>
        public string Tag { get; }
        /// <summary> The name of the artifact. </summary>
        public string Name { get; }
        /// <summary> The version of the artifact. </summary>
        public string Version { get; }
    }
}
