// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The content of the event request message. </summary>
    public partial class ContainerRegistryArtifactEventData
    {
        /// <summary> Initializes a new instance of <see cref="ContainerRegistryArtifactEventData"/>. </summary>
        internal ContainerRegistryArtifactEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryArtifactEventData"/>. </summary>
        /// <param name="id"> The event ID. </param>
        /// <param name="timestamp"> The time at which the event occurred. </param>
        /// <param name="action"> The action that encompasses the provided event. </param>
        /// <param name="location"> The location of the event. </param>
        /// <param name="target"> The target of the event. </param>
        /// <param name="connectedRegistry"> The connected registry information if the event is generated by a connected registry. </param>
        internal ContainerRegistryArtifactEventData(string id, DateTimeOffset? timestamp, string action, string location, ContainerRegistryArtifactEventTarget target, ContainerRegistryEventConnectedRegistry connectedRegistry)
        {
            Id = id;
            Timestamp = timestamp;
            Action = action;
            Location = location;
            Target = target;
            ConnectedRegistry = connectedRegistry;
        }

        /// <summary> The event ID. </summary>
        public string Id { get; }
        /// <summary> The time at which the event occurred. </summary>
        public DateTimeOffset? Timestamp { get; }
        /// <summary> The action that encompasses the provided event. </summary>
        public string Action { get; }
        /// <summary> The location of the event. </summary>
        public string Location { get; }
        /// <summary> The target of the event. </summary>
        public ContainerRegistryArtifactEventTarget Target { get; }
        /// <summary> The connected registry information if the event is generated by a connected registry. </summary>
        public ContainerRegistryEventConnectedRegistry ConnectedRegistry { get; }
    }
}
