// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.Models
{
    internal partial class CloudEventInternal : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("id"u8);
            writer.WriteStringValue(Id);
            writer.WritePropertyName("source"u8);
            writer.WriteStringValue(Source);
            if (Optional.IsDefined(Data))
            {
                writer.WritePropertyName("data"u8);
                Data.WriteTo(writer);
            }
            if (Optional.IsDefined(DataBase64))
            {
                writer.WritePropertyName("data_base64"u8);
                writer.WriteBase64StringValue(DataBase64, "D");
            }
            writer.WritePropertyName("type"u8);
            writer.WriteStringValue(Type);
            if (Optional.IsDefined(Time))
            {
                writer.WritePropertyName("time"u8);
                writer.WriteStringValue(Time.Value, "O");
            }
            writer.WritePropertyName("specversion"u8);
            writer.WriteStringValue(Specversion);
            if (Optional.IsDefined(Dataschema))
            {
                writer.WritePropertyName("dataschema"u8);
                writer.WriteStringValue(Dataschema);
            }
            if (Optional.IsDefined(Datacontenttype))
            {
                writer.WritePropertyName("datacontenttype"u8);
                writer.WriteStringValue(Datacontenttype);
            }
            if (Optional.IsDefined(Subject))
            {
                writer.WritePropertyName("subject"u8);
                writer.WriteStringValue(Subject);
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
                writer.WriteObjectValue<object>(item.Value);
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
