// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for Microsoft.AVS/scriptExecutions events. </summary>
    public partial class AvsScriptExecutionEventData
    {
        /// <summary> Initializes a new instance of <see cref="AvsScriptExecutionEventData"/>. </summary>
        internal AvsScriptExecutionEventData()
        {
            Output = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AvsScriptExecutionEventData"/>. </summary>
        /// <param name="operationId"> Id of the operation that caused this event. </param>
        /// <param name="cmdletId"> Cmdlet referenced in the execution that caused this event. </param>
        /// <param name="output"> Stdout outputs from the execution, if any. </param>
        internal AvsScriptExecutionEventData(string operationId, string cmdletId, IReadOnlyList<string> output)
        {
            OperationId = operationId;
            CmdletId = cmdletId;
            Output = output;
        }

        /// <summary> Id of the operation that caused this event. </summary>
        public string OperationId { get; }
        /// <summary> Cmdlet referenced in the execution that caused this event. </summary>
        public string CmdletId { get; }
        /// <summary> Stdout outputs from the execution, if any. </summary>
        public IReadOnlyList<string> Output { get; }
    }
}
