// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AvsPrivateCloudFailedEventDataConverter))]
    public partial class AvsPrivateCloudFailedEventData
    {
        internal static AvsPrivateCloudFailedEventData DeserializeAvsPrivateCloudFailedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string failureMessage = default;
            string operationId = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("failureMessage"u8))
                {
                    failureMessage = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("operationId"u8))
                {
                    operationId = property.Value.GetString();
                    continue;
                }
            }
            return new AvsPrivateCloudFailedEventData(operationId, failureMessage);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new AvsPrivateCloudFailedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAvsPrivateCloudFailedEventData(document.RootElement);
        }

        internal partial class AvsPrivateCloudFailedEventDataConverter : JsonConverter<AvsPrivateCloudFailedEventData>
        {
            public override void Write(Utf8JsonWriter writer, AvsPrivateCloudFailedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AvsPrivateCloudFailedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAvsPrivateCloudFailedEventData(document.RootElement);
            }
        }
    }
}
