// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for Microsoft.AVS/clusters events. </summary>
    public partial class AvsClusterEventData
    {
        /// <summary> Initializes a new instance of <see cref="AvsClusterEventData"/>. </summary>
        internal AvsClusterEventData()
        {
            AddedHostNames = new ChangeTrackingList<string>();
            RemovedHostNames = new ChangeTrackingList<string>();
            InMaintenanceHostNames = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AvsClusterEventData"/>. </summary>
        /// <param name="operationId"> Id of the operation that caused this event. </param>
        /// <param name="addedHostNames"> Hosts added to the cluster in this event, if any. </param>
        /// <param name="removedHostNames"> Hosts removed to the cluster in this event, if any. </param>
        /// <param name="inMaintenanceHostNames"> Hosts in Maintenance mode in the cluster, if any. </param>
        internal AvsClusterEventData(string operationId, IReadOnlyList<string> addedHostNames, IReadOnlyList<string> removedHostNames, IReadOnlyList<string> inMaintenanceHostNames)
        {
            OperationId = operationId;
            AddedHostNames = addedHostNames;
            RemovedHostNames = removedHostNames;
            InMaintenanceHostNames = inMaintenanceHostNames;
        }

        /// <summary> Id of the operation that caused this event. </summary>
        public string OperationId { get; }
        /// <summary> Hosts added to the cluster in this event, if any. </summary>
        public IReadOnlyList<string> AddedHostNames { get; }
        /// <summary> Hosts removed to the cluster in this event, if any. </summary>
        public IReadOnlyList<string> RemovedHostNames { get; }
        /// <summary> Hosts in Maintenance mode in the cluster, if any. </summary>
        public IReadOnlyList<string> InMaintenanceHostNames { get; }
    }
}
