// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Detail of action on the app service plan. </summary>
    public partial class AppServicePlanEventTypeDetail
    {
        /// <summary> Initializes a new instance of <see cref="AppServicePlanEventTypeDetail"/>. </summary>
        internal AppServicePlanEventTypeDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppServicePlanEventTypeDetail"/>. </summary>
        /// <param name="stampKind"> Kind of environment where app service plan is. </param>
        /// <param name="action"> Type of action on the app service plan. </param>
        /// <param name="status"> Asynchronous operation status of the operation on the app service plan. </param>
        internal AppServicePlanEventTypeDetail(StampKind? stampKind, AppServicePlanAction? action, AsyncStatus? status)
        {
            StampKind = stampKind;
            Action = action;
            Status = status;
        }

        /// <summary> Kind of environment where app service plan is. </summary>
        public StampKind? StampKind { get; }
        /// <summary> Type of action on the app service plan. </summary>
        public AppServicePlanAction? Action { get; }
        /// <summary> Asynchronous operation status of the operation on the app service plan. </summary>
        public AsyncStatus? Status { get; }
    }
}
