// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AppConfigurationSnapshotModifiedEventDataConverter))]
    public partial class AppConfigurationSnapshotModifiedEventData
    {
        internal static AppConfigurationSnapshotModifiedEventData DeserializeAppConfigurationSnapshotModifiedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string etag = default;
            string syncToken = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("etag"u8))
                {
                    etag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("syncToken"u8))
                {
                    syncToken = property.Value.GetString();
                    continue;
                }
            }
            return new AppConfigurationSnapshotModifiedEventData(name, etag, syncToken);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new AppConfigurationSnapshotModifiedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAppConfigurationSnapshotModifiedEventData(document.RootElement);
        }

        internal partial class AppConfigurationSnapshotModifiedEventDataConverter : JsonConverter<AppConfigurationSnapshotModifiedEventData>
        {
            public override void Write(Utf8JsonWriter writer, AppConfigurationSnapshotModifiedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AppConfigurationSnapshotModifiedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAppConfigurationSnapshotModifiedEventData(document.RootElement);
            }
        }
    }
}
