// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of common properties of snapshot events. </summary>
    public partial class AppConfigurationSnapshotEventData
    {
        /// <summary> Initializes a new instance of <see cref="AppConfigurationSnapshotEventData"/>. </summary>
        internal AppConfigurationSnapshotEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppConfigurationSnapshotEventData"/>. </summary>
        /// <param name="name"> The name of the snapshot. </param>
        /// <param name="eTag"> The etag representing the new state of the snapshot. </param>
        /// <param name="syncToken"> The sync token representing the server state after the event. </param>
        internal AppConfigurationSnapshotEventData(string name, string eTag, string syncToken)
        {
            Name = name;
            ETag = eTag;
            SyncToken = syncToken;
        }

        /// <summary> The name of the snapshot. </summary>
        public string Name { get; }
        /// <summary> The sync token representing the server state after the event. </summary>
        public string SyncToken { get; }
    }
}
