// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AppConfigurationSnapshotEventDataConverter))]
    public partial class AppConfigurationSnapshotEventData
    {
        internal static AppConfigurationSnapshotEventData DeserializeAppConfigurationSnapshotEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string etag = default;
            string syncToken = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("etag"u8))
                {
                    etag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("syncToken"u8))
                {
                    syncToken = property.Value.GetString();
                    continue;
                }
            }
            return new AppConfigurationSnapshotEventData(name, etag, syncToken);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AppConfigurationSnapshotEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAppConfigurationSnapshotEventData(document.RootElement);
        }

        internal partial class AppConfigurationSnapshotEventDataConverter : JsonConverter<AppConfigurationSnapshotEventData>
        {
            public override void Write(Utf8JsonWriter writer, AppConfigurationSnapshotEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AppConfigurationSnapshotEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAppConfigurationSnapshotEventData(document.RootElement);
            }
        }
    }
}
