// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AppConfigurationSnapshotCreatedEventDataConverter))]
    public partial class AppConfigurationSnapshotCreatedEventData
    {
        internal static AppConfigurationSnapshotCreatedEventData DeserializeAppConfigurationSnapshotCreatedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string etag = default;
            string syncToken = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("etag"u8))
                {
                    etag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("syncToken"u8))
                {
                    syncToken = property.Value.GetString();
                    continue;
                }
            }
            return new AppConfigurationSnapshotCreatedEventData(name, etag, syncToken);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new AppConfigurationSnapshotCreatedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAppConfigurationSnapshotCreatedEventData(document.RootElement);
        }

        internal partial class AppConfigurationSnapshotCreatedEventDataConverter : JsonConverter<AppConfigurationSnapshotCreatedEventData>
        {
            public override void Write(Utf8JsonWriter writer, AppConfigurationSnapshotCreatedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AppConfigurationSnapshotCreatedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAppConfigurationSnapshotCreatedEventData(document.RootElement);
            }
        }
    }
}
