// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the data property of an EventGridEvent for a Microsoft.ApiCenter.ApiDefinitionUpdated event. </summary>
    public partial class ApiCenterApiDefinitionUpdatedEventData
    {
        /// <summary> Initializes a new instance of <see cref="ApiCenterApiDefinitionUpdatedEventData"/>. </summary>
        internal ApiCenterApiDefinitionUpdatedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApiCenterApiDefinitionUpdatedEventData"/>. </summary>
        /// <param name="title"> API definition title. </param>
        /// <param name="description"> API definition description. </param>
        /// <param name="specification"> API specification details. </param>
        internal ApiCenterApiDefinitionUpdatedEventData(string title, string description, ApiCenterApiSpecification specification)
        {
            Title = title;
            Description = description;
            Specification = specification;
        }

        /// <summary> API definition title. </summary>
        public string Title { get; }
        /// <summary> API definition description. </summary>
        public string Description { get; }
        /// <summary> API specification details. </summary>
        public ApiCenterApiSpecification Specification { get; }
    }
}
