// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the data property of an EventGridEvent for a Microsoft.ApiCenter.ApiDefinitionAdded event. </summary>
    public partial class ApiCenterApiDefinitionAddedEventData
    {
        /// <summary> Initializes a new instance of <see cref="ApiCenterApiDefinitionAddedEventData"/>. </summary>
        internal ApiCenterApiDefinitionAddedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApiCenterApiDefinitionAddedEventData"/>. </summary>
        /// <param name="title"> API definition title. </param>
        /// <param name="description"> API definition description. </param>
        /// <param name="specification"> API specification details. </param>
        internal ApiCenterApiDefinitionAddedEventData(string title, string description, ApiCenterApiSpecification specification)
        {
            Title = title;
            Description = description;
            Specification = specification;
        }

        /// <summary> API definition title. </summary>
        public string Title { get; }
        /// <summary> API definition description. </summary>
        public string Description { get; }
        /// <summary> API specification details. </summary>
        public ApiCenterApiSpecification Specification { get; }
    }
}
