// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The type of engagement user have with email. </summary>
    public readonly partial struct AcsUserEngagement : IEquatable<AcsUserEngagement>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcsUserEngagement"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcsUserEngagement(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ViewValue = "view";
        private const string ClickValue = "click";

        /// <summary> view. </summary>
        public static AcsUserEngagement View { get; } = new AcsUserEngagement(ViewValue);
        /// <summary> click. </summary>
        public static AcsUserEngagement Click { get; } = new AcsUserEngagement(ClickValue);
        /// <summary> Determines if two <see cref="AcsUserEngagement"/> values are the same. </summary>
        public static bool operator ==(AcsUserEngagement left, AcsUserEngagement right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcsUserEngagement"/> values are not the same. </summary>
        public static bool operator !=(AcsUserEngagement left, AcsUserEngagement right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcsUserEngagement"/>. </summary>
        public static implicit operator AcsUserEngagement(string value) => new AcsUserEngagement(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcsUserEngagement other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcsUserEngagement other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
