// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AcsUserDisconnectedEventDataConverter))]
    public partial class AcsUserDisconnectedEventData
    {
        internal static AcsUserDisconnectedEventData DeserializeAcsUserDisconnectedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CommunicationIdentifierModel userCommunicationIdentifier = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("userCommunicationIdentifier"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    userCommunicationIdentifier = CommunicationIdentifierModel.DeserializeCommunicationIdentifierModel(property.Value);
                    continue;
                }
            }
            return new AcsUserDisconnectedEventData(userCommunicationIdentifier);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsUserDisconnectedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsUserDisconnectedEventData(document.RootElement);
        }

        internal partial class AcsUserDisconnectedEventDataConverter : JsonConverter<AcsUserDisconnectedEventData>
        {
            public override void Write(Utf8JsonWriter writer, AcsUserDisconnectedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AcsUserDisconnectedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAcsUserDisconnectedEventData(document.RootElement);
            }
        }
    }
}
