// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AcsSmsDeliveryReportReceivedEventDataConverter))]
    public partial class AcsSmsDeliveryReportReceivedEventData
    {
        internal static AcsSmsDeliveryReportReceivedEventData DeserializeAcsSmsDeliveryReportReceivedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string deliveryStatus = default;
            string deliveryStatusDetails = default;
            IReadOnlyList<AcsSmsDeliveryAttemptProperties> deliveryAttempts = default;
            DateTimeOffset? receivedTimestamp = default;
            string tag = default;
            string messageId = default;
            string @from = default;
            string to = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deliveryStatus"u8))
                {
                    deliveryStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("deliveryStatusDetails"u8))
                {
                    deliveryStatusDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("deliveryAttempts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AcsSmsDeliveryAttemptProperties> array = new List<AcsSmsDeliveryAttemptProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AcsSmsDeliveryAttemptProperties.DeserializeAcsSmsDeliveryAttemptProperties(item));
                    }
                    deliveryAttempts = array;
                    continue;
                }
                if (property.NameEquals("receivedTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    receivedTimestamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("tag"u8))
                {
                    tag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("messageId"u8))
                {
                    messageId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("from"u8))
                {
                    @from = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("to"u8))
                {
                    to = property.Value.GetString();
                    continue;
                }
            }
            return new AcsSmsDeliveryReportReceivedEventData(
                messageId,
                @from,
                to,
                deliveryStatus,
                deliveryStatusDetails,
                deliveryAttempts ?? new ChangeTrackingList<AcsSmsDeliveryAttemptProperties>(),
                receivedTimestamp,
                tag);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new AcsSmsDeliveryReportReceivedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsSmsDeliveryReportReceivedEventData(document.RootElement);
        }

        internal partial class AcsSmsDeliveryReportReceivedEventDataConverter : JsonConverter<AcsSmsDeliveryReportReceivedEventData>
        {
            public override void Write(Utf8JsonWriter writer, AcsSmsDeliveryReportReceivedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AcsSmsDeliveryReportReceivedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAcsSmsDeliveryReportReceivedEventData(document.RootElement);
            }
        }
    }
}
