// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterWorkerUpdated event. </summary>
    public partial class AcsRouterWorkerUpdatedEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterWorkerUpdatedEventData"/>. </summary>
        internal AcsRouterWorkerUpdatedEventData()
        {
            QueueAssignments = new ChangeTrackingList<AcsRouterQueueDetails>();
            ChannelConfigurations = new ChangeTrackingList<AcsRouterChannelConfiguration>();
            Labels = new ChangeTrackingDictionary<string, string>();
            Tags = new ChangeTrackingDictionary<string, string>();
            UpdatedWorkerProperties = new ChangeTrackingList<AcsRouterUpdatedWorkerProperty>();
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterWorkerUpdatedEventData"/>. </summary>
        /// <param name="workerId"> Router Worker Updated Worker Id. </param>
        /// <param name="queueAssignments"> Router Worker Updated Queue Info. </param>
        /// <param name="channelConfigurations"> Router Worker Updated Channel Configuration. </param>
        /// <param name="totalCapacity"> Router Worker Updated Total Capacity. </param>
        /// <param name="labels"> Router Worker Updated Labels. </param>
        /// <param name="tags"> Router Worker Updated Tags. </param>
        /// <param name="updatedWorkerProperties"> Router Worker Properties Updated. </param>
        internal AcsRouterWorkerUpdatedEventData(string workerId, IReadOnlyList<AcsRouterQueueDetails> queueAssignments, IReadOnlyList<AcsRouterChannelConfiguration> channelConfigurations, int? totalCapacity, IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags, IReadOnlyList<AcsRouterUpdatedWorkerProperty> updatedWorkerProperties)
        {
            WorkerId = workerId;
            QueueAssignments = queueAssignments;
            ChannelConfigurations = channelConfigurations;
            TotalCapacity = totalCapacity;
            Labels = labels;
            Tags = tags;
            UpdatedWorkerProperties = updatedWorkerProperties;
        }

        /// <summary> Router Worker Updated Worker Id. </summary>
        public string WorkerId { get; }
        /// <summary> Router Worker Updated Queue Info. </summary>
        public IReadOnlyList<AcsRouterQueueDetails> QueueAssignments { get; }
        /// <summary> Router Worker Updated Channel Configuration. </summary>
        public IReadOnlyList<AcsRouterChannelConfiguration> ChannelConfigurations { get; }
        /// <summary> Router Worker Updated Total Capacity. </summary>
        public int? TotalCapacity { get; }
        /// <summary> Router Worker Updated Labels. </summary>
        public IReadOnlyDictionary<string, string> Labels { get; }
        /// <summary> Router Worker Updated Tags. </summary>
        public IReadOnlyDictionary<string, string> Tags { get; }
        /// <summary> Router Worker Properties Updated. </summary>
        public IReadOnlyList<AcsRouterUpdatedWorkerProperty> UpdatedWorkerProperties { get; }
    }
}
