// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AcsRouterWorkerUpdatedEventDataConverter))]
    public partial class AcsRouterWorkerUpdatedEventData
    {
        internal static AcsRouterWorkerUpdatedEventData DeserializeAcsRouterWorkerUpdatedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string workerId = default;
            IReadOnlyList<AcsRouterQueueDetails> queueAssignments = default;
            IReadOnlyList<AcsRouterChannelConfiguration> channelConfigurations = default;
            int? totalCapacity = default;
            IReadOnlyDictionary<string, string> labels = default;
            IReadOnlyDictionary<string, string> tags = default;
            IReadOnlyList<AcsRouterUpdatedWorkerProperty> updatedWorkerProperties = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("workerId"u8))
                {
                    workerId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("queueAssignments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AcsRouterQueueDetails> array = new List<AcsRouterQueueDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AcsRouterQueueDetails.DeserializeAcsRouterQueueDetails(item));
                    }
                    queueAssignments = array;
                    continue;
                }
                if (property.NameEquals("channelConfigurations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AcsRouterChannelConfiguration> array = new List<AcsRouterChannelConfiguration>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AcsRouterChannelConfiguration.DeserializeAcsRouterChannelConfiguration(item));
                    }
                    channelConfigurations = array;
                    continue;
                }
                if (property.NameEquals("totalCapacity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalCapacity = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("labels"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    labels = dictionary;
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("updatedWorkerProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AcsRouterUpdatedWorkerProperty> array = new List<AcsRouterUpdatedWorkerProperty>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new AcsRouterUpdatedWorkerProperty(item.GetString()));
                    }
                    updatedWorkerProperties = array;
                    continue;
                }
            }
            return new AcsRouterWorkerUpdatedEventData(
                workerId,
                queueAssignments ?? new ChangeTrackingList<AcsRouterQueueDetails>(),
                channelConfigurations ?? new ChangeTrackingList<AcsRouterChannelConfiguration>(),
                totalCapacity,
                labels ?? new ChangeTrackingDictionary<string, string>(),
                tags ?? new ChangeTrackingDictionary<string, string>(),
                updatedWorkerProperties ?? new ChangeTrackingList<AcsRouterUpdatedWorkerProperty>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsRouterWorkerUpdatedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsRouterWorkerUpdatedEventData(document.RootElement);
        }

        internal partial class AcsRouterWorkerUpdatedEventDataConverter : JsonConverter<AcsRouterWorkerUpdatedEventData>
        {
            public override void Write(Utf8JsonWriter writer, AcsRouterWorkerUpdatedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AcsRouterWorkerUpdatedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAcsRouterWorkerUpdatedEventData(document.RootElement);
            }
        }
    }
}
