// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AcsRouterWorkerRegisteredEventDataConverter))]
    public partial class AcsRouterWorkerRegisteredEventData
    {
        internal static AcsRouterWorkerRegisteredEventData DeserializeAcsRouterWorkerRegisteredEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string workerId = default;
            IReadOnlyList<AcsRouterQueueDetails> queueAssignments = default;
            IReadOnlyList<AcsRouterChannelConfiguration> channelConfigurations = default;
            int? totalCapacity = default;
            IReadOnlyDictionary<string, string> labels = default;
            IReadOnlyDictionary<string, string> tags = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("workerId"u8))
                {
                    workerId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("queueAssignments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AcsRouterQueueDetails> array = new List<AcsRouterQueueDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AcsRouterQueueDetails.DeserializeAcsRouterQueueDetails(item));
                    }
                    queueAssignments = array;
                    continue;
                }
                if (property.NameEquals("channelConfigurations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AcsRouterChannelConfiguration> array = new List<AcsRouterChannelConfiguration>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AcsRouterChannelConfiguration.DeserializeAcsRouterChannelConfiguration(item));
                    }
                    channelConfigurations = array;
                    continue;
                }
                if (property.NameEquals("totalCapacity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalCapacity = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("labels"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    labels = dictionary;
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
            }
            return new AcsRouterWorkerRegisteredEventData(
                workerId,
                queueAssignments ?? new ChangeTrackingList<AcsRouterQueueDetails>(),
                channelConfigurations ?? new ChangeTrackingList<AcsRouterChannelConfiguration>(),
                totalCapacity,
                labels ?? new ChangeTrackingDictionary<string, string>(),
                tags ?? new ChangeTrackingDictionary<string, string>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsRouterWorkerRegisteredEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsRouterWorkerRegisteredEventData(document.RootElement);
        }

        internal partial class AcsRouterWorkerRegisteredEventDataConverter : JsonConverter<AcsRouterWorkerRegisteredEventData>
        {
            public override void Write(Utf8JsonWriter writer, AcsRouterWorkerRegisteredEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AcsRouterWorkerRegisteredEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAcsRouterWorkerRegisteredEventData(document.RootElement);
            }
        }
    }
}
